/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;
import jade.core.Location;
import jade.mtp.TransportAddress;

public class ContainerID
implements Location {
    public static final String DEFAULT_IMTP = "JADE-IMTP";
    private String name;
    private String address;

    public ContainerID() {
    }

    public ContainerID(String n, TransportAddress a) {
        this.name = n;
        this.address = a != null ? a.getHost() : "<Unknown Host>";
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setProtocol(String p) {
    }

    public String getProtocol() {
        return DEFAULT_IMTP;
    }

    public void setAddress(String a) {
        this.address = a;
    }

    public String getAddress() {
        return this.address;
    }

    public String getID() {
        return this.name + '@' + DEFAULT_IMTP + "://" + this.address;
    }

    public String toString() {
        return this.getID();
    }

    public boolean equals(Object obj) {
        try {
            ContainerID cid = (ContainerID)obj;
            return CaseInsensitiveString.equalsIgnoreCase(this.name, cid.getName());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }
}

